<?php

vc_map( array(
  'name' => esc_html__( 'Accordion', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_accordion',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/accordion.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add accordion / toggles', 'wplab-albedo-core-plugin' ),
  'as_parent' => array( 'only' => 'albedo_accordion_section' ),
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/accordion/js/vc.js',
  'content_element' => true,
  'is_container' => true,
  'show_settings_on_create' => true,
  'js_view' => is_admin() ? 'VcColumnView' : 'ViewAlbedoAccordion',
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Element style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Choose from one of available styles', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'admin_label' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Active dark', 'wplab-albedo-core-plugin') => 'active_dark',
        esc_html__('Simple, big titles', 'wplab-albedo-core-plugin') => 'simple',
      ),
    ),

  )
));

vc_map( array(
  'name' => esc_html__( 'Accordion Section', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_accordion_section',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/accordion.png',
  'content_element' => true,
  'as_child' => array( 'only' => 'albedo_accordion' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'value' => '',
      'admin_label' => true,
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'value' => '',
    ),

  )
));
