<?php
  global $wplab_albedo_core;
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
	$attributes = $classes = array();

	$id = esc_attr( $atts['el_id'] );
	$attributes[] = 'id="shortcode-' . $id . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

	$attributes[] = 'data-init-slide="' . absint( $atts['init_slide'] ) . '"';

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

	$items = $wplab_albedo_core->model('post')->get( array(
		'post_type' => 'media_slides',
		'type' => $atts['query_type'],
		'posts_per_page' => absint( $atts['posts_per_page'] ),
		'order' => $atts['order_by'],
		'sort' => $atts['sort_by'],
		'tax_name' => 'media_slides_category',
    'term_field' => 'slug',
		'terms' => $terms
	) );

?>

<div class="shortcode-videos-carousel <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">

      <?php while ( $items->have_posts() ): $items->the_post(); ?>

      <div class="swiper-slide">
        <div class="slide-content">

          <figure class="img-shortcode-wrapper" data-src="<?php echo esc_attr( fw_get_db_post_option( get_the_ID(), 'video_url' ) ); ?>">
            <?php $img = get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>
            <a href="<?php echo esc_attr( $img ); ?>">
              <?php echo wplab_albedo_media::image( $img, absint( $atts['image_width'] ), absint( $atts['image_height'] ), true, true, $img, false, array(), array('alt="' . esc_attr( get_the_title() ) . '"') ); ?>
            </a>
          </figure>

        </div>
      </div>

      <?php endwhile; wp_reset_postdata(); ?>

    </div>

	</div>

	<?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
	<div class="pagination-buttons">
  	<a href="javascript:;" class="pagination-btn swiper-button-prev"></a>
  	<a href="javascript:;" class="pagination-btn swiper-button-next"></a>
	</div>
  <?php endif; ?>

</div>
