<?php
	global $wplab_albedo_core;
	$id = esc_attr( $atts['el_id'] );

	/** unique id **/
	$attributes[] = 'id="shortcode-' . $id . '"';
	$attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
	$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'testimonials',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'testimonials_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div class="shortcode-testimonials-carousel3 <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">
			<?php
				while ( $items->have_posts() ): $items->the_post();
			  $text = get_the_content();
			  $photo = get_the_post_thumbnail_url( get_the_ID(), 'full');
			?>
			<div class="swiper-slide" data-img-url="<?php echo esc_attr( $photo ); ?>">
			  <div class="slide-content">

			    <div class="row">
			      <?php if( $photo <> '' ): ?>
			      <div class="col-md-6">
			        <div class="photo">
			          <?php echo wplab_albedo_media::image( $photo, false, false, true, true, $photo ); ?>
			        </div>
			      </div>
			      <?php endif; ?>
			      <div class="col-md-<?php echo $photo <> '' ? '6' : '12'; ?>">

			        <?php if( $text <> '' ): ?>
			        <div class="text">
			          <?php echo wp_kses_post( $text ); ?>
			        </div>
			        <?php endif; ?>

			        <?php
								$sign_src = fw_get_db_post_option( get_the_ID(), 'sign' );
			          $sign = isset( $sign_src['url'] ) ? $sign_src['url'] : '';
			          if( $sign <> '' ):
			            echo '<div class="sign">' . wplab_albedo_media::image( $sign, false, false, true, true, $sign ) . '</div>';
			          endif;
			        ?>

			      </div>
			    </div>

			  </div>
			</div>
			<?php endwhile; wp_reset_postdata(); ?>
    </div>

	</div>

	<?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- If we need pagination -->
  <div class="swiper-pagination"></div>
  <?php endif; ?>

  <?php if( filter_var( $atts['pagination_arrows'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- Prev / next buttons -->
  <div class="swiper-nav-btn swiper-button-prev"></div>
  <div class="swiper-nav-btn swiper-button-next"></div>
  <?php endif; ?>

</div>
