<div <?php echo implode( ' ', $attributes ); ?> class="shortcode-services-iconic" id="shortcode-<?php echo esc_attr( $atts['el_id'] ); ?>">

  <?php
    $animated = filter_var( $atts['animate_on_display'], FILTER_VALIDATE_BOOLEAN );
  	$animation = $animated ? $atts['animate_on_display_effect'] : '';
  	$animation_delay = $animated ? $atts['animate_on_display_delay'] : '';

  	$animated_on_hover = filter_var( $atts['animate_on_hover'], FILTER_VALIDATE_BOOLEAN );
  	$hover_animation = $animated_on_hover ? $atts['animate_on_hover_effect'] : '';
  ?>

  <div class="row">

    <div class="item col-md-12 <?php echo $atts['icon_type'] == '' ? 'no-icon' : ''; ?> <?php if( $animated ): ?>wow <?php echo esc_attr( $animation ); endif; ?>" <?php if( $animated ): ?>data-wow-delay="<?php echo esc_attr( $animation_delay ); ?>s"<?php endif; ?>>
      <div class="item-inside">

          <?php if( $atts['icon_type'] == 'fontawesome' ): ?>

          <div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr( $hover_animation); ?>">
            <i class="<?php echo esc_attr( $atts['icon_font'] ); ?>"></i>
          </div>

          <?php elseif( $atts['icon_type'] == 'custom' ): ?>

          <div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr( $hover_animation); ?>">
            <?php wplab_albedo_media::image_src( $atts['icon_image'] ); ?>
          </div>

          <?php endif; ?>

          <div class="text">

            <?php if( $atts['category'] <> '' ): ?>
            <div class="category"><?php echo wp_kses_post( $atts['category'] ); ?></div>
            <?php endif; ?>

            <?php if( $atts['link'] <> '' ): ?>
            <a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN )): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>">
            <?php endif; ?>

            <?php if( $atts['title'] <> '' ): ?>
            <h4><?php echo wp_kses_post( $atts['title'] ); ?></h4>
            <?php endif; ?>

            <?php if( $atts['link'] <> '' ): ?>
            </a>
            <?php endif; ?>

            <?php if( $atts['text'] <> '' ): ?>
            <?php
              $text = $atts['text'];
              $text = preg_replace("/\*+(.*)?/i","<ul><li>$1</li></ul>", $text);
              $text = preg_replace("/(\<\/ul\>\n(.*)\<ul\>*)+/","", $text);
            ?>
            <div class="desc"><?php echo wp_kses_post( $text ); ?></div>
            <?php endif; ?>

            <?php if( $atts['link'] <> '' && filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
            <a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN )): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>" class="button style-<?php echo esc_attr( $atts['button_style'] ); ?> size-small"><?php echo wp_kses_post( $atts['button_title'] ); ?></a>
            <?php endif; ?>

          </div>

      </div>
    </div>

  </div>

</div>
