<?php

/**
 * @var $atts The shortcode attributes
 */
global $wplab_albedo_core;
$atts['tpl'] = 'template-parts/blog/media-grid';

// get a current page from query
$paged = get_query_var( 'paged' );

// extend $atts variable
$atts['paged'] = $paged == 0 ? 1 : $paged;
$atts['tax_query_terms'] = array();

if( is_post_type_archive( 'post' ) || is_tag() || is_category() || is_home() ) {

	global $wp_query;
	$posts = $wp_query;

	$atts['tax_query_type'] = $atts['tax_query_terms'] = '';

	$query_args = array(
		'type' => 'all',
		'posts_per_page' => get_option( 'posts_per_page' ),
		'category' => '',
		'term_field' => 'slug',
		'post_type' => 'post',
		'tax_name' => 'category',
		'paged' => $atts['paged'],
		'order' => 'date',
		'sort' => 'DESC',
	);

} else {

  if( in_array( $atts['tax_query_type'], array( 'only', 'except') ) ) {
    $cats_str = $atts['tax_query_terms'];
		$atts['tax_query_terms'] = explode(',', $cats_str );
  }

	/**
	 * Get posts
	 **/
	$query_args = array(
		'type' => $atts['tax_query_type'] <> '' ? $atts['tax_query_type'] : 'all',
		'posts_per_page' => isset( $atts['posts_per_page'] ) && $atts['posts_per_page'] <> '' ? absint( $atts['posts_per_page'] ) : 9,
		'terms' => $atts['tax_query_terms'],
		'term_field' => 'slug',
		'post_type' => 'post',
		'tax_name' => 'category',
		'paged' => $atts['paged'],
		'order' => isset( $atts['order_by'] ) && $atts['order_by'] <> '' ? $atts['order_by'] : 'date',
		'sort' => isset( $atts['sort_by'] ) && $atts['sort_by'] <> '' ? $atts['sort_by'] : 'DESC',
		'featured_only' => filter_var( $atts['featured_only'], FILTER_VALIDATE_BOOLEAN )
	);

	$posts = $wplab_albedo_core->model('post')->get( $query_args );

}

$atts['query_data'] = $query_args;
$atts['max_num_pages'] = $posts->max_num_pages;

// Additional Tpl params in Unyson Framework format
$tpl_params = array(
	'id' => $atts['el_id'],
  'thumbs_dimensions' => array(
    'type' => $atts['thumbs_dimensions'],
    'crop' => array(
      'thumb_width' => $atts['thumb_width'],
      'thumb_height' => $atts['thumb_height'],
    )
  ),
	'pagination' => array(
		'yes' => array(
			'pagination_style' => array(
				'ajax_load_more' => array(
					'button_style' => $atts['ajax_load_more_button_style'],
					'button_text' => $atts['ajax_load_more_button_text'],
				)
			)
		)
	),
  'display_excerpt' => array(
    'enabled' => $atts['display_excerpt'],
    'yes' => array(
      'excerpt_length' => $atts['excerpt_length']
    )
  )
);

$tpl_vars = array_merge( $atts, $tpl_params);

set_query_var( 'wplab_albedo_tpl_settings', $tpl_vars );

/**
  * Display posts
**/
if( $posts->have_posts() ):
?>
<div <?php echo implode( ' ', $attributes ); ?> id="shortcode-<?php echo esc_attr( $atts['el_id'] ); ?>" class="shortcode-blog-media-grid cols-<?php echo absint( $atts['large_screen_cols'] ); ?> cols-medium-<?php echo absint( $atts['medium_screen_cols'] ); ?> cols-small-<?php echo absint( $atts['small_screen_cols'] ); ?>">

	<div id="posts-container-id-<?php echo esc_attr( $atts['el_id'] ); ?>" class="blog-media-grid-posts">
	<?php while ( $posts->have_posts() ): $posts->the_post(); ?>

		<?php get_template_part( $atts['tpl'] ); ?>

  <?php endwhile; ?>
	</div>

	<?php
		// Display posts pagination?
		if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ):
			get_template_part( 'template-parts/pagination/style_' . $atts['pagination_style'] );
		endif;
	?>

</div>
<?php
wp_reset_postdata(); endif;
