<?php

  /**
    * Vertical Timeline Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Timeline_V extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        
        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-timeline-v', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/timeline_v.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/timeline_v_variable.less') );
        wp_enqueue_style( 'wplab-albedo-timeline-v-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'sticky-kit');
    		wp_enqueue_script( 'wplab-albedo-timeline-v', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/timeline-v/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_timeline_v.php';
        return ob_get_clean();

      }

    }
  }
