<?php

vc_map( array(
  'name' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_services',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/services.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/services-iconic/js/vc.js',
	'category' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add services', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Category (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'category',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Service icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_type',
      'value' => array(
        esc_html__('Without Icon', 'wplab-albedo-core-plugin') => '',
        esc_html__('Choose an icon from Icon Library', 'wplab-albedo-core-plugin') => 'fontawesome',
        esc_html__('Upload custom Image icon', 'wplab-albedo-core-plugin') => 'custom',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'iconpicker',
      'heading' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_font',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'fontawesome' ),
  		),
      'settings' => array(
        'emptyIcon' => true,
        'type' => 'fontawesome',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Upload icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_image',
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'custom' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Style tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open links at new tab', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_title',
      'save_always' => true,
      'value' => esc_html__( 'VIEW DETAILS', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Here you can choose pre-defined styles for a button', 'wplab-albedo-core-plugin'),
      'param_name' => 'button_style',
      'save_always' => true,
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on display', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_display_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display_delay',
      'save_always' => true,
      'value' => '0.2',
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Icon color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'icon_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Icon hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'icon_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Category text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'category_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Ordered list text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'list_text_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'List bullets color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'list_bullets_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),

  )
));
