<?php

  /**
    * Portfolio Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Portfolio extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    		if( filter_var( $atts['filters'], FILTER_VALIDATE_BOOLEAN ) ) {
          $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/filters.less') );
    			wp_enqueue_style( 'wplab-albedo-filters-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		}

    		wp_enqueue_style( 'wplab-albedo-portfolio', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/portfolio.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/portfolio_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-portfolio-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/** include Justified Grid **/
    		wp_enqueue_style( 'justified-grid', get_template_directory_uri() . '/css/libs/justified.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_script( 'justified-grid');

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-portfolio', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/portfolio/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		/**
    		 * Custom style settings
    		 **/
        $custom_css = '';

    		if( $atts['custom_radius'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' img, #' . $shortcode_id . ' .overlay, #' . $shortcode_id . ' .item { border-radius: ' . $atts['custom_radius'] . 'px; }';
    		}

    		if( $atts['filters_link_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters a { color: ' . $atts['filters_link_color'] . '; }';
    		}

    		if( $atts['filters_link_active_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters a.active, #' . $shortcode_id . ' .posts-filters a:hover { color: ' . $atts['filters_link_active_color'] . '; }';
    		}

    		if( $atts['filters_separator_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters { color: ' . $atts['filters_separator_color'] . '; }';
    		}

        if( $custom_css <> '' ) {
          $wrap_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_portfolio.php';
        return ob_get_clean();

      }

    }
  }
