<?php

  /**
    * Logos Carousel Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Logos_Carousel extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $id = $atts['el_id'];
        $shortcode_id = 'shortcode-' . esc_attr( $id );
        $attributes[] = 'id="' . $shortcode_id . '"';

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

    		/** include swiper carousel library styles **/
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'swiper');

    		/** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-logos-carousel', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/logos_carousel.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/logos_carousel_variable.less') );
        wp_enqueue_style( 'wplab-albedo-logos-carousel-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-logos-carousel', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/logos-carousel/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

    		/**
    		 * Custom colors
    		 **/

         $custom_css = '';

    		if( $atts['pagination_bullets_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .swiper-pagination-bullet { background-color: ' . $atts['pagination_bullets_color'] . '; }';
    		}

    		if( $atts['pagination_bullets_hover_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .swiper-pagination-bullet-active { background-color: ' . $atts['pagination_bullets_hover_color'] . '; }';
    		}

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css="' . $custom_css . '"';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_logos_carousel.php';
        return ob_get_clean();

      }

    }
  }
