<?php

vc_map( array(
  'name' => esc_html__( 'Logos Carousel', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_logos_carousel',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/logos-carousel.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/logos-carousel/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add logos carousel', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'attach_images',
      'heading' => esc_html__('Add images', 'wplab-albedo-core-plugin'),
      'param_name' => 'images',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Apply hover opacity effect', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_opacity_effect',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (big screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_big',
      'save_always' => true,
      'value' => '3',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (medium screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_medium',
      'save_always' => true,
      'value' => '2',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (small screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_small',
      'save_always' => true,
      'value' => '1',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Carousel Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Slide', 'wplab-albedo-core-plugin') => 'slide',
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'fade',
        esc_html__('Cube', 'wplab-albedo-core-plugin') => 'cube',
        esc_html__('Coverflow', 'wplab-albedo-core-plugin') => 'coverflow',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'flip',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'value' => '2000',
      'save_always' => true,
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Loop slider', 'wplab-albedo-core-plugin' ),
      'param_name' => 'loop',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Pagination bullets color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'pagination_bullets_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Pagination active bullet color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'pagination_bullets_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),

  )
));
