<?php

vc_map( array(
  'name' => esc_html__( 'Google Map', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_google_map',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/map.png',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add Google Map', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Google API Key', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Insert here your Google API Key to avoid request limitations and JavaScript errors.', 'wplab-albedo-core-plugin' ),
      'param_name' => 'api_key',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Location Address', 'wplab-albedo-core-plugin' ),
      'param_name' => 'address',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Pin Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'pin_icon',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Map Height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set map height (Ex: 300)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'map_height',
      'save_always' => true,
      'value' => '300',
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Map type', 'wplab-albedo-core-plugin'),
      'param_name' => 'map_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Roadmap', 'wplab-albedo-core-plugin') => 'roadmap',
        esc_html__('Terrain', 'wplab-albedo-core-plugin') => 'terrain',
        esc_html__('Satellite', 'wplab-albedo-core-plugin') => 'satellite',
        esc_html__('Hybrid', 'wplab-albedo-core-plugin') => 'hybrid',
      ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__( 'Map zoom', 'wplab-albedo-core-plugin' ),
      'param_name' => 'zoom',
      'save_always' => true,
      'value' => array(
        '16' => '16',
        '15' => '15',
        '14' => '14',
        '13' => '13',
        '12' => '12',
        '11' => '11',
        '10' => '10',
        '9' => '9',
        '8' => '8',
        '7' => '7',
        '6' => '6',
        '5' => '5',
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable zoom on scroll', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Prevent the map from zooming when scrolling until clicking on the map', 'wplab-albedo-core-plugin' ),
      'param_name' => 'disable_scrolling',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display shadow', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

  )
));
