<?php

vc_map( array(
  'name' => esc_html__( 'Checkbox', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_contact_form_checkbox',
  'content_element' => true,
  'category' => esc_html__( 'Form Fields', 'wplab-albedo-core-plugin' ),
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/multiple-choice.png',
  'as_child' => array( 'only' => 'albedo_contact_form,vc_column_inner' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Label', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enter field label (it will be displayed on the web site)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'label',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Choices', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'One choice per one line', 'wplab-albedo-core-plugin' ),
      'param_name' => 'choices',
      'value' => '',
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Instructions for Users', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'The users will see these instructions in the tooltip near the field', 'wplab-albedo-core-plugin' ),
      'param_name' => 'description',
      'value' => '',
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Field name', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'description' => esc_html__( 'Used in "name" attribute', 'wplab-albedo-core-plugin' ),
    ),

  )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Albedo_Contact_Form_Checkbox extends WPBakeryShortCode {
  }
}
