<?php

vc_map( array(
  'name' => esc_html__( 'Single Post Block', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_blog_post',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/single-post-block.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/blog-post/js/vc.js',
	'category' => esc_html__( 'Blog', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add single post block', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Post format', 'wplab-albedo-core-plugin'),
      'param_name' => 'post_format',
      'admin_label' => true,
      'value' => array(
        esc_html__('Standard', 'wplab-albedo-core-plugin') => 'standard',
        esc_html__('Audio', 'wplab-albedo-core-plugin') => 'audio',
        esc_html__('Video', 'wplab-albedo-core-plugin') => 'video',
        esc_html__('Gallery', 'wplab-albedo-core-plugin') => 'gallery',
        esc_html__('Quote', 'wplab-albedo-core-plugin') => 'quote',
        esc_html__('Link', 'wplab-albedo-core-plugin') => 'link',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Featured posts only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'featured_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Appearance tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post thumbnail', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'only for standard post type', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_thumb',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post excerpt', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_excerpt',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Excerpt lenght', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'how many words should we display?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'excerpt_length',
      'value' => '13',
      'dependency' => array(
  			'element' => 'display_excerpt',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post date', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_date',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post author', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_author',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display shadows', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Overlay color', 'wplab-albedo-core-plugin'),
      'param_name' => 'overlay_color',
      'value' => $this->cfg['base_colors'],
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text align', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_align',
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom radius for posts', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 30', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom paddings', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 60', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_paddings',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Block height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 30', 'wplab-albedo-core-plugin' ),
      'param_name' => 'height',
      'value' => '450',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Thumbnails dimensions', 'wplab-albedo-core-plugin'),
      'param_name' => 'thumbs_dimensions',
      'value' => array(
        esc_html__('Original size', 'wplab-albedo-core-plugin') => '',
        esc_html__('Crop thumbnails', 'wplab-albedo-core-plugin') => 'crop',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_width',
      'value' => '320',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_height',
      'value' => '180',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

	),
));
