<?php

vc_map( array(
  'name' => esc_html__( 'Blog Posts Carousel 2', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_blog_carousel2',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/blog-posts-carousel-02.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/blog-carousel2/js/vc.js',
	'category' => esc_html__( 'Blog', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add Blog Posts Carousel', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts per page', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'admin_label' => true,
      'value' => '9',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Featured posts only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'featured_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Carousel tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Initial slide', 'wplab-albedo-core-plugin' ),
      'param_name' => 'initial_slide',
      'value' => '1',
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides number for large screens', 'wplab-albedo-core-plugin' ),
      'param_name' => 'slides_num',
      'value' => '2',
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides number for small screens', 'wplab-albedo-core-plugin' ),
      'param_name' => 'slides_num_small',
      'value' => '1',
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display thumbnails', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_thumb',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display date', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_date',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post excerpt', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_excerpt',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Excerpt lenght', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'how many words should we display?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'excerpt_length',
      'value' => '13',
      'dependency' => array(
        'element' => 'display_excerpt',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display author', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_author',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'value' => '2000',
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Overlay color', 'wplab-albedo-core-plugin'),
      'param_name' => 'overlay_color',
      'value' => $this->cfg['base_colors'],
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Pagination position', 'wplab-albedo-core-plugin'),
      'param_name' => 'pagination_position',
      'value' => array(
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom radius', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 30', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Thumbnails dimensions', 'wplab-albedo-core-plugin'),
      'param_name' => 'thumbs_dimensions',
      'value' => array(
        esc_html__('Original size', 'wplab-albedo-core-plugin') => '',
        esc_html__('Crop thumbnails', 'wplab-albedo-core-plugin') => 'crop',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_width',
      'value' => '320',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_height',
      'value' => '180',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

	),
));
